//
//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit
import MessageUI

class ContactUsController: UIViewController{
    
    //MARK:- viewDidLoad()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupScrollView()
        pageSetup()

    }
    
    //MARK:- Page Setup
    
    func pageSetup() {
        
        let greenBack = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth, height: 255))
        greenBack.backgroundColor = .UltraLightGreen()
        self.scrollView.addSubview(greenBack)
        
        let card = UILabel(frame: CGRect(x: 20, y: 268, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.scrollView.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "CUP")
        Picture.frame = CGRect(x: 20, y: 15, width: screenWidth-40, height: 220)
        self.scrollView.addSubview(Picture)
        
        
        let line1 = UIButton()
        line1.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line1.center = CGPoint(x: screenWidth/2, y: 340)
        line1.backgroundColor = .gray
        line1.layer.cornerRadius = 1
        line1.clipsToBounds = true
        self.scrollView.addSubview(line1)
        
        let line2 = UIButton()
        line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line2.center = CGPoint(x: screenWidth/2, y: 412)
        line2.backgroundColor = .gray
        line2.layer.cornerRadius = 1
        line2.clipsToBounds = true
        self.scrollView.addSubview(line2)
        
        let line3 = UIButton()
        line3.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line3.center = CGPoint(x: screenWidth/2, y: 484)
        line3.backgroundColor = .gray
        line3.layer.cornerRadius = 1
        line3.clipsToBounds = true
        self.scrollView.addSubview(line3)
        
        let line4 = UIButton()
        line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line4.center = CGPoint(x: screenWidth/2, y: 556)
        line4.backgroundColor = .gray
        line4.layer.cornerRadius = 1
        line4.clipsToBounds = true
        self.scrollView.addSubview(line4)
        
        let phoneNumberImg = UIImage(named: "Phone")
        let phoneNumber = UIButton()
        phoneNumber.frame = CGRect(x: 50, y: 288, width: 40, height: 40)
        phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
        phoneNumber.layer.cornerRadius = 20;
        phoneNumber.clipsToBounds = true
        self.scrollView.addSubview(phoneNumber)
        
        let phoneLabel = UILabel()
        phoneLabel.frame = CGRect(x: screenWidth/2-240, y: 288, width: 500, height: 40)
        phoneLabel.textAlignment = NSTextAlignment.center
        phoneLabel.text = "+91 98105 21315"
        phoneLabel.textColor = .black
        phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.scrollView.addSubview(phoneLabel)
        
        let emailImg = UIImage(named: "gmail")
        let Email = UIButton()
        Email.frame = CGRect(x: 50, y: 355, width: 40, height: 40)
        Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
        Email.layer.cornerRadius = 20;
        Email.clipsToBounds = true
        self.scrollView.addSubview(Email)
        
        let emailLabel = UILabel()
        emailLabel.frame = CGRect(x: screenWidth/2-230, y: 355, width: 500, height: 40)
        emailLabel.textAlignment = NSTextAlignment.center
        emailLabel.text = "ecowarriorsvg@gmail.com"
        emailLabel.textColor = .black
        emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.scrollView.addSubview(emailLabel)
        
        let AddressImg = UIImage(named: "Adress")
        let Address = UIButton()
        Address.frame = CGRect(x: 50, y: 427, width: 40, height: 40)
        Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
        Address.layer.cornerRadius = 20;
        Address.clipsToBounds = true
        self.scrollView.addSubview(Address)
        
        let AddressLabel = UILabel()
        AddressLabel.frame = CGRect(x: screenWidth/2-230, y: 427, width: 500, height: 40)
        AddressLabel.textAlignment = NSTextAlignment.center
        AddressLabel.text = "T6-2O2, Vipul Greens"
        AddressLabel.textColor = .black
        AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.scrollView.addSubview(AddressLabel)
        
        let InstaImg = UIImage(named: "Insta")
        let Insta = UIButton()
        Insta.frame = CGRect(x: 50, y: 499, width: 40, height: 40)
        Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
        Insta.layer.cornerRadius = 20;
        Insta.clipsToBounds = true
        Insta.addTarget(self, action: #selector(instagram), for: .touchUpInside)
        self.scrollView.addSubview(Insta)
        
        
        let instaLabel = UILabel()
        instaLabel.frame = CGRect(x: screenWidth/2-240, y: 499, width: 500, height: 40)
        instaLabel.textAlignment = NSTextAlignment.center
        instaLabel.text = "@VGEcoWarriors"
        instaLabel.textColor = .black
        instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.scrollView.addSubview(instaLabel)
        
        let TwitterImg = UIImage(named: "Twitter")
        let Twitter = UIButton()
        Twitter.frame = CGRect(x: 50, y: 571, width: 40, height: 40)
        Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
        Twitter.layer.cornerRadius = 20;
        Twitter.clipsToBounds = true
        Twitter.addTarget(self, action: #selector(twitter), for: .touchUpInside)
        self.scrollView.addSubview(Twitter)
        
        let TwitterLabel = UILabel()
        TwitterLabel.frame = CGRect(x: screenWidth/2-240, y: 571, width: 500, height: 40)
        TwitterLabel.textAlignment = NSTextAlignment.center
        TwitterLabel.text = "@Eco_VG"
        TwitterLabel.textColor = .black
        TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.scrollView.addSubview(TwitterLabel)

        
        //MARK:- Navigation Bar
        
        self.navigationItem.title = "Contact us"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationController?.navigationBar.barStyle = .black
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationItem.rightBarButtonItem = UIBarButtonItem(image:#imageLiteral(resourceName: "logo1").withRenderingMode(.alwaysOriginal), style: .plain , target: self, action: #selector(doNothing))
    }
    
    //MARK:- Page Functions
    
     //MARK:- instagram
    @objc func instagram() {
        if let url = URL(string: "https://www.instagram.com/vgecowarriors/") {
            UIApplication.shared.open(url)
        }
    }
    
     //MARK:- twitter
    @objc func twitter() {
        if let url = URL(string: "https://twitter.com/eco_vg") {
            UIApplication.shared.open(url)
        }
    }

    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
    
    @objc func doNothing(_ sender:UIButton!) {
        
    }
    
    @objc func mail(_ sender:UIButton!) {
        
        guard MFMailComposeViewController.canSendMail() else {
            return
        }

        let composer = MFMailComposeViewController()
        composer.mailComposeDelegate = self
        composer.setToRecipients(["ecowarriorsvg@gmail.com"])
        composer.setMessageBody("Dear EcoWarriors,\n\nI want to be a part of the team! My information is:\n\nName:\nPhone Number:\nTower Number:\nFlat Number:", isHTML: false)
        composer.setSubject("Application")
        present(composer, animated: true)
    }
    
    //MARK:- Scroll View
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.translatesAutoresizingMaskIntoConstraints = false
        view.contentSize.height = screenHeight-200
        view.backgroundColor = .white
        return view
    }()
    
    func setupScrollView() {
        view.addSubview(scrollView)
        scrollView.topAnchor.constraint(equalTo: view.topAnchor).isActive = true
        scrollView.bottomAnchor.constraint(equalTo: view.bottomAnchor).isActive = true
        scrollView.leftAnchor.constraint(equalTo: view.leftAnchor).isActive = true
        scrollView.rightAnchor.constraint(equalTo: view.rightAnchor).isActive = true
    }
}

extension UIViewController: MFMailComposeViewControllerDelegate {
    public func mailComposeController(_ controller: MFMailComposeViewController, didFinishWith result: MFMailComposeResult, error: Error?) {
        if let _ = error {
            controller.dismiss(animated: true)
            return
        }
        
        switch result {
        case .sent:
            print("Sent")
        case .failed:
            print("Failed")
        case .cancelled:
            print("Cancelled")
        case .saved:
            print("Saved")
        @unknown default:
            return
        }
        
        controller.dismiss(animated: true)
    }
}
